<?php
/**
 * jDiction plugin
 *
 * @package jDiction
 * @link http://joomla.itronic.at
 * @copyright	Copyright (C) 2011 ITronic Harald Leithner. All rights reserved.
 * @license GNU General Public License v3
 *
 * This file is part of jDiction.
 *
 * jDiction is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * jDiction is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jDiction.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
defined('_JEXEC') or die;

jimport('joomla.event.plugin');

//load jdiction framework
jimport('jdiction.jdiction');

class plgSystemjDiction extends JPlugin {

	public function __construct(& $subject, $config = array()) {
		parent::__construct($subject, $config);

	}
	
	/**
	 * replace database object
	 * @return void
	 */
	public function onAfterInitialise() {
		
		$jd = jDiction::getInstance();
		$jd->initialise();
		
	}
	
	/**
	 * run after Route
	 */
	public function onAfterRoute() {
    $jd = jDiction::getInstance();
    $jd->addToolbar();
		$component = $jd->getComponent(JFactory::getApplication()->input->get('option', null, 'cmd'));
	  if ($component) {
	  	if (JFactory::getApplication()->isAdmin()) {
	      JHtml::register('Grid.id', array($this, 'gridIdHook'));
		  }
		}
	}


  /**
   * jDiction after save content method
   * Article is passed by reference, but after the save, so no changes will be saved.
   * Method is called right after the content is saved
   *
   * @param	string		$context The context of the content passed to the plugin (added in 1.6)
   * @param	object		$table A JTableContent object
   * @param	bool		$isNew If the content has just been created
   * @since	2.5
   */
  public function onContentAfterSave($context, $table, $isNew) {
    // We don't need new Items atm
    if ($isNew) {
      return;
    }

    $jd = jDiction::getInstance();

    list($ext, $view) = explode('.',$context);
    $component = $jd->getComponent($ext);
    if (!$component) {
      return;
    }
    $jdtable = $jd->getTableByView($ext, $view);

    if (!array_key_exists($view, $component)) {
      return;
    }

    $db = JFactory::getDbo();
    $query = $db->getQuery(true);

    $query->update('#__jd_store');
    $query->set($db->qn('state').'='.$db->q(2));
    $query->where($db->qn('state').'='.$db->q(1));
    $query->where($db->qn('idReference').'='.$db->q($table->{$jdtable->key}));
    $query->where($db->qn('referenceTable').'='.$db->q($jdtable->name));
    $query->where($db->qn('referenceOption').'='.$db->q($component->name));
    $query->where($db->qn('referenceView').'='.$db->q($view));

    $db->setQuery($query);
    $db->execute();
  }

  public function gridIdHook() {
		$row = func_get_arg(0);
		$id = func_get_arg(1);
		$vars = func_get_args();
		$res = call_user_func_array('JHtmlGrid::id', $vars);
		$jd = jdiction::getInstance();
    $ext = JFactory::getApplication()->input->get('option', '', 'cmd');
    $view = $jd->getView($ext, JFactory::getApplication()->input->get('view', 'default', 'cmd'));
    if (!$view) {
      return $res;
    }
    $table = $jd->getTableByView($ext, $view->name);
    $layout = $view->layout;

    JHtml::_('behavior.framework');
    $doc = JFactory::getDocument();
    $doc->addScript(JUri::root(false).'/administrator/components/com_jdiction/assets/jdiction.js');

    $result = array();

    $languages = $jd->getLanguages();
    foreach($languages as $language) {
		  $result['status'][$language->image] = $jd->getTranslationStatus($table->name, $id, $language->lang_id);
    }

		$result['link'] = $jd->getTranslationLink($ext, $view->name, $layout, $id, false);
		
		// create array
    if ($row == 0) {
			$res .= '<script>var jdiction = {};</script>';
		}
    $res .= '<script>jdiction['.$row.']='.json_encode($result).';</script>';

		return $res;
	
	}
}
