<?php
/**
 * @version		$Id$
 * @package		Joomla.Site
 * @subpackage	mod_languages
 * @copyright	Copyright (C) 2005 - 2011 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

jimport('joomla.language.helper');
jimport('joomla.utilities.utility');

abstract class modJdLanguageHelper {
  /**
   * Creates a link to the Active page in the given language if exists, if not redirect to the Startpage
   * @static
   * @param $lang Object the Language Object returned by jdiction::getLanguages
   * @return array With Link and Title
   */
  public static function getLink($lang) {

    $config = JFactory::getConfig();
		$app = JFactory::getApplication();
    $input = $app->input;
		$menu = $app->getMenu();
		$active = $menu->getActive();
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('path, id, home, title');
		$query->from('#__menu');
		$query->where('id='.$active->id);
		$query->where('language in ('.$db->q($lang->lang_code).', '.$db->q('*').')');

		//replace current language with target language
		$orig_lang = $db->getLanguage();
		$db->setLanguage($lang->lang_code);
    $orig_translate = $db->setTranslate(true);
    $db->setQuery($query);
    $menuitem = $db->loadObject();
    $db->setTranslate($orig_translate);
    $db->setLanguage($orig_lang);

		$option = $input->get('option', $active->query['option'], 'cmd');
		$view = $input->get('view', $active->query['view'], 'cmd');
		$layout = $input->get('layout', $active->query['layout'], 'string');
		$id = $input->get('id', $active->query['id'], 'int');

    $query = array();
    $query_sef = array();

    if ($option) {
      $query[] = 'option='.$option;
      if ($active->query['option'] != $option) {
        $query_sef[] = 'option='.$option;
      }
    }

    if ($view) {
      $query[] = 'view='.$view;
      if ($active->query['view'] != $view) {
        $query_sef[] = 'view='.$view;
      }
    }

    if ($id) {
      $query[] = 'id='.$id;
      if ($active->query['id'] != $id) {
        $query_sef[] = 'id='.$id;
      }
    }

    if ($layout) {
      $query[] = 'layout='.$layout;
      if ($active->query['layout'] != $layout) {
        $query_sef[] = 'layout='.$layout;
      }
    }

    //check if we use sef_rewrite
    $link = JURI::root();

    if ($menuitem && $config->get('sef')) {
      if (!$config->get('sef_rewrite')) {
        $link = JURI::root().'index.php/';
      }
      $link .= $lang->sef;
      if (!$menuitem->home) {
        $link .= '/'.$menuitem->path;
      }
      if (!empty($query_sef)) {
        $link .= '?'.implode('&', $query_sef);
      }
    } else {
      $link .= 'index.php?';
      if ($menuitem) {
        if ($menuitem->home) {
          if (!empty($query_sef)) {
            $link .= implode('&', $query_sef);
          }
        } else {
          if (!empty($query)) {
            $link .= implode('&', $query).'&';
          }
          $link .= 'Itemid='.$menuitem->id.'&';
        }
      }
      $link .= 'lang='.$lang->sef;
    }

		return array($link, $menuitem->title);
	}
}
