<?php
/**
 * @package jDiction
 * @link http://joomla.itronic.at
 * @copyright	Copyright (C) 2011 ITronic Harald Leithner. All rights reserved.
 * @license GNU General Public License v3
 *
 * This file is part of jDiction.
 *
 * jDiction is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * jDiction is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jDiction.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modelform');

/**
 * Methods supporting a list of Translation records.
 *
 * @package		jDiction
 */
class jDictionModelExport extends JModelForm {
	/**
	 * @var		string	The prefix to use with controller messages.
	 */
	protected $text_prefix = 'COM_JDICTION_UPLOAD';

	/**
	 * returns all languages
	 */
	public function getLanguages() {
		$jd = jdiction::getInstance();
		$languages = $jd->getLanguages();
		return $languages;
	}
	
	 
		
	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param	string $type	The table type to instantiate
	 * @param	string $prefix	A prefix for the table class name. Optional.
	 * @param	array	$config Configuration array for model. Optional.
	 * @return	JTable	A database object
	 * @since	1.6
	 */
	public function getTable($type = 'store', $prefix = 'jDictionTable', $config = array()) {
		return parent::getTable($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param	array	$data		Data for the form.
	 * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return	mixed	A JForm object on success, false on failure
	 * @since	1.6
	 */
	public function getForm($data = array(), $loadData = true) {
		// Get the form.
		$form = $this->loadForm('com_jdiction.download', 'download', array('control' => 'jform', 'load_data' => $loadData));
								
		if (empty($form)) {
			return false;
		}
		return $form;
	}
	
	/**
	 * returns the url to the list
	 */
	public function getListUrl($option, $view) {
		
		$jd = jdiction::getInstance();
		$component = $jd->getComponent($option);
		$view = $component[$view]->list;
		
		return $view;
	}

} 
