<?php
/**
 * @package jDiction
 * @link http://joomla.itronic.at
 * @copyright	Copyright (C) 2011 ITronic Harald Leithner. All rights reserved.
 * @license GNU General Public License v3
 *
 * This file is part of jDiction.
 *
 * jDiction is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * jDiction is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jDiction.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

/**
 * Translation Controller
 *
 * @package jDiction
 */
class jDictionControllerTools extends JControllerForm {
	/**
	 * @var		string	The prefix to use with controller messages.
	 */
	protected $text_prefix = 'COM_JDICTION_TRANSLATION';

  /**
   * exports the selected Language to csv
   */
  public function export() {
		// Set output format to raw
    JFactory::getApplication()->input->set('format', 'raw');

		// Prepare variables
    $jdiction = jDiction::getInstance();
    $components = $jdiction->getComponent();
		$jform = JFactory::getApplication()->input->get('jform', null, 'array');
		
		if (isset($jform['deduplicate'])) {
			$deduplicate = $jform['deduplicate'];
		} else {
      $deduplicate = true;
    }

		if (isset($jform['tables'])) {
			$exporttables = $jform['tables'];
		}

		if (isset($jform['language'])) {
			$language = $jform['language'];
		} else {
      $language = JComponentHelper::getParams('com_languages')->get('site', 'en-GB');
    }
    // Do we export the native Language?
		$native = ($language == JComponentHelper::getParams('com_languages')->get('site', 'en-GB'));
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$header = array();
    $data = array();

		// Prepare columns
    foreach($components as $com=>$views) {
			$header[$com] = array();

			foreach($views as $view) {
        if (!is_null($exporttables) && !in_array($com.'.'.$view->name, $exporttables)) {
          continue;
        }

        $query->clear();

        $table = $jdiction->getTable($view->primarytable);
        $query->from($table->name);
        $query->select($db->quoteName($table->key).' as '.$db->quote('JDKEY'));
        if ($table->exportfilter) {
          $query->where((string)$table->exportfilter);
        }

				$header[$com][$view->name] = array();
        $layout = $view->layout;
        unset($form);
        $form = $view->form;

        $fields = $form->xpath('//fieldset/field');
        foreach($fields as $field) {
          if (($field->attributes()->export) && (strtoupper((string)$field->attributes()->export) == "FALSE")) {
            continue;
          }
          $name = (string)$field->attributes()->name;
          if (($table->name == '#__content') && ($name == 'articletext')) {
            $name = 'introtext';
            $header[$com.'.'.$view->name.'.'.$layout.'.'.$name] = $name;
            $query->select($db->quoteName($name).' as '.$db->quote($com.'.'.$view->name.'.'.$layout.'.'.$name));
            $name = 'fulltext';
          }
          $header[$com.'.'.$view->name.'.'.$layout.'.'.$name] = $name;
          $query->select($db->quoteName($name).' as '.$db->quote($com.'.'.$view->name.'.'.$layout.'.'.$name));
        }
        $fields = $form->xpath('//fieldset/fields');
        foreach($fields as $field) {
          $name = (string)$field->attributes()->name;
          $subfields = $field->xpath('//fields/field');
          $query->select($db->quoteName($name).' as '.$db->quote($com.'.'.$view->name.'.'.$layout.'.'.$name));
          foreach($subfields as $subfield) {
            $subname = (string)$subfield->attributes()->name;
            $header[$com.'.'.$view->name.'.'.$layout.'.'.$name][$subname] = $subname;
          }
        }
        if (!$native) {
          $db->setTranslate(true);
          $oldlangauge = $db->getLanguage();
          $db->setLanguage($language);
        }
        $db->setQuery($query);
        $data = array_merge((array) $data, (array)$db->loadAssocList());
        if (!$native) {
          $db->setTranslate(false);
          $db->setLanguage($oldlangauge);
        }
      }
    }

    // Allocate 12 MB for content and 12 MB for dedublication
		$file = fopen('php://temp/maxmemory:'. (12*1024*1024), 'w+');
		$defile = fopen('php://temp/maxmemory:'. (12*1024*1024), 'w+');
		$dedup = array();
    foreach ($data as $row) {
      $jdkey = $row['JDKEY'];
      foreach ($row as $key=>$value) {
        if ($key == 'JDKEY') {
          continue;
        }
        if (is_array($header[$key])) {
          $tmp = json_decode($value, true);
          foreach($header[$key] as $subkey=>$subvalue) {
            if (trim($tmp[$subkey]) == '') {
              continue;
            }
            if ($deduplicate && array_key_exists((string)$tmp[$subkey], $dedup)) {
              jDictionTranslationHelper::fputcsv($defile, array($jdkey, $key.'.'.$subkey, $dedup[(string)$tmp[$subkey]]),';','"','"');
            } else {
              $dedup[(string)$tmp[$subkey]] = "REF:".$jdkey.'.'.$key.'.'.$subkey;
              jDictionTranslationHelper::fputcsv($file, array($jdkey, $key.'.'.$subkey, $tmp[$subkey]),';','"','"');
            }
          }
        } else {
          if (trim($value) == '') {
            continue;
          }
          if ($deduplicate && array_key_exists((string)$value, $dedup)) {
            jDictionTranslationHelper::fputcsv($defile, array($jdkey, $key, $dedup[(string)$value]),';','"','"');
          } else {
            $dedup[(string)$value] = "REF:".$jdkey.'.'.$key;
            jDictionTranslationHelper::fputcsv($file, array($jdkey, $key, $value),';','"','"');
          }
        }
      }
    }

    // Finish output and send it to the browser as Download
		rewind($file);
		rewind($defile);
    $output = stream_get_contents($file);
    $output .= stream_get_contents($defile);
    fclose($file);
    fclose($defile);
		header("Content-type: application/octet-stream");
 		header("Content-Disposition: attachment; filename=\"jdiction.csv\"");
		echo $output;
		Jexit();
	}

  /**
   * import File to Database
   * @return bool
   */
  public function import() {

    // Prepare variables
		$input = JFactory::getApplication()->input;
		$data = $input->get('jform', null, 'array');
		$language = $data['language'];
		// Should we override native language
    $native = ($language == JComponentHelper::getParams('com_languages')->get('site', 'en-GB'));
		$filetype = $data['csv'];
		$dedup = array();
		$metadata = array();
		
		$files = new JInput($_FILES, array());
		$file = $files->get('jform', null, 'array');

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		if (empty($file) or empty($file['name']['translation'])) {
			$this->setMessage(JText::_("COM_JDICTION_YOU_NEED_TO_SUPPLY_A_TRANSLATION_FILE"));
			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=import'
					. $this->getRedirectToItemAppend(), false
				)
			);
			return false;
		}
		
		if (substr($file['name']['translation'],-3) != 'csv') {
			$this->setMessage(JText::_("COM_JDICTION_WE_ONLY_SUPPORT_CSV_FILES"));
			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=import'
					. $this->getRedirectToItemAppend(), false
				)
			);
			return false;
		}
		
		$inputfile = $file['tmp_name']['translation'];

    // Read CSV File
		if (($handle = fopen($inputfile, "r")) !== FALSE) {
			$translation = array();

			while (($data = fgetcsv($handle, 10000, ";", '"')) !== FALSE) {
				$dedup[$data[0].'.'.$data[1]] = $data[2];

				$path = explode('.',$data[1]);
				$root = array();
				$target = & $root;
				foreach($path as $item) {
					$target[$item] = array();
					$target = & $target[$item];
				}
				
				$target[$data[0]] = $data[2]; 
				
				$translation = jDictionTranslationHelper::array_merge_recursive($translation, $root);
			}
		fclose($handle);
		}

    $jdiction = jDiction::getInstance();
    $components = $jdiction->getComponent();

    $header = array();
		foreach($components as $com=>$views) {
			foreach($views as $view) {
        $query->clear();
        $layout = $view->layout;
        $form = $view->form;

        $fields = $form->xpath('//fieldset/field');
        foreach($fields as $field) {
          if (($field->attributes()->export) && (strtoupper((string)$field->attributes()->export) == "FALSE")) {
            continue;
          }
          $name = (string)$field->attributes()->name;
          if (($com == 'com_content') && ($name == 'articletext')) {
            $name = 'introtext';
            $header[$com][$view->name][$layout][$name] = $name;
            $name = 'fulltext';
          }
          $header[$com][$view->name][$layout][$name] = $name;
        }
        $fields = $form->xpath('//fieldset/fields');
        foreach($fields as $field) {
          $name = (string)$field->attributes()->name;
          $subfields = $field->xpath('//fields/field');
          foreach($subfields as $subfield) {
            $subname = (string)$subfield->attributes()->name;
            $header[$com][$view->name][$layout][$name][$subname] = $subname;
          }
        }
			}
		}

		$model = JModel::getInstance('translation', 'jdictionModel');
		foreach($header as $com=>$views) {
			foreach($views as $view=>$layouts) {
				foreach($layouts as $layout=>$fields) {
					$store = array();
					foreach($fields as $field=>$data) {
						if (isset($translation[$com]) && isset($translation[$com][$view]) && isset($translation[$com][$view][$layout]) && isset($translation[$com][$view][$layout][$field])) {
							foreach($translation[$com][$view][$layout][$field] as $id=>$item) {
								if (is_array($item)) {
									foreach($item as $id2=>$item2) {
										if (substr($item2, 0, 4) == 'REF:') {
											list($null, $dedupkey) = explode(':',$item2, 2);
											if (array_key_exists($dedupkey, $dedup)) {
												$item2 = $dedup[$dedupkey];
											}
										}
										$store[$id2][$language][$field][$id] = $item2;
									}
								} else {
									if (substr($item, 0, 4) == 'REF:') {
										list($null, $dedupkey) = explode(':',$item, 2);
										if (array_key_exists($dedupkey, $dedup)) {
											$item = $dedup[$dedupkey];
										}
									}

									if ($com == 'com_content' && $field == 'introtext') {
										// Workaround for #__content
										if ($translation[$com][$view][$layout]['fulltext'][$id]) {
											$item2 = $translation[$com][$view][$layout]['fulltext'][$id];
											if (substr($item2, 0, 4) == 'REF:') {
												list($null, $dedupkey) = explode(':',$item2, 2);
												if (array_key_exists($dedupkey, $dedup)) {
													$item2 = $dedup[$dedupkey];
												}
											}
											
											$store[$id][$language]['articletext'] = $item . '<hr id="system-readmore" />' . $item2;
										} else {
											$store[$id][$language]['articletext'] = $item;
										}
									}
									$store[$id][$language][$field] = $item;
								}
							}
						}
					}
					
					$input->set('jd_option', $com);
					$input->set('jd_view', $view);
					$input->set('jd_layout', $layout);
					foreach($store as $id=>$data) {
						//we override the native language
						if ($native) {

              $table = $jdiction->getTableByView($com, $view);
							$query->clear();
							$query->update($table->name);
							$query->where($db->qn($table->key).' = '.$db->q($id));
							foreach($data[$language] as $field=>$value) {
								if (is_array($value)) {
									$query->set($db->qn($field).' = '.$db->q(json_encode($value)));
								} else {
                  $query->set($db->qn($field).' = '.$db->q($value));
								}
							}
							
							$db->setQuery($query);
							if (!$db->query()) {
                die('query, db error');
							}
							
						//we update a translation
						} else {
							$input->set('jd_id', $id);
							$form = $model->getForm($data, false);
							if ($form) {
								// Test whether the data is valid.
								if ($validData = $model->validate($form, $data)) {
                  $result = $model->save($validData);
                } else {
                  // Error
                }
							} else {
								//printpre($form, $data, $input);
							}
						}
					}
					
				}
			}
		}
		
		$this->setRedirect(
			JRoute::_(
				'index.php?option=' . $this->option . '&view=' . $this->view_list
				. $this->getRedirectToListAppend(), false
			)
		);
	}
	
	public function cancel() {
		$this->setRedirect(
			JRoute::_(
				'index.php?option=' . $this->option . '&view=' . $this->view_list
				. $this->getRedirectToListAppend(), false
			)
		);
	}
}
