<?php
/**
 * jDiction library entry point
 *
 * @package jDiction
 * @link http://joomla.itronic.at
 * @copyright	Copyright (C) 2011 ITronic Harald Leithner. All rights reserved.
 * @license GNU General Public License v3
 * @version 1.6.1 (18)
 *
 * This file is part of jDiction.
 *
 * jDiction is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * jDiction is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jDiction.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
defined('_JEXEC') or die;

// Register dependent classes.
/*JLoader::register('JdFinderIndexer', dirname(__FILE__) . '/indexer.php');
JLoader::register('JdFinderIndexerHelper', dirname(__FILE__) . '/helper.php');
JLoader::register('JdFinderIndexerResult', dirname(__FILE__) . '/result.php');
JLoader::register('JdFinderIndexerTaxonomy', dirname(__FILE__) . '/taxonomy.php');
*/

jimport('joomla.application.component.helper');

// Load the base adapter.
require_once JPATH_ADMINISTRATOR . '/components/com_finder/helpers/indexer/adapter.php';


/**
 * Prototype adapter class for the Finder indexer package with jDiction support.
 *
 */
abstract class JdFinderIndexerAdapter extends FinderIndexerAdapter {

  /**
   * @param object $subject The object to observe
   * @param array $config An array that holds the plugin configuration
   */
  public function __construct(&$subject, $config) {
    parent::__construct($subject, $config);
    $this->loadLanguage();
  }

  /**
   * Method to get a list of content items to index.
   *
   * @param   integer         $offset  The list offset.
   * @param   integer         $limit   The list limit.
   * @param   JDatabaseQuery  $sql     A JDatabaseQuery object. [optional]
   *
   * @return  array  An array of FinderIndexerResult objects.
   *
   * @since   2.5
   * @throws  Exception on database error.
   */
  protected function getItems($offset, $limit, $sql = null) {
    JLog::add('FinderIndexerAdapter::getItems', JLog::INFO);

    $items = array();

    $jDiction = jDiction::getInstance();
    $languages = $jDiction->getLanguages(true);
    $db = JFactory::getDbo();
    $oldTranslation = $db->getTranslate();
    $oldLanguage = $db->getLanguage();

    $columns = $db->getTableColumns($this->table);

    foreach($languages as $language) {
      // Get the content items to index.
      $query = $this->getListQuery();

      $db->setTranslate(true);
      $language = $language->lang_code;
      $db->setLanguage($language);

      if (array_key_exists('language', $columns)) {
        $query->where('a.language in ('.$db->q('*').','.$db->q($language).')');
      }

      if ($sql != '') {
        $query->where($sql);
      }
      $this->db->setQuery($query, $offset, $limit);
      $rows = $this->db->loadAssocList();

      // Check for a database error.
      if ($this->db->getErrorNum()) {
        // Throw database error exception.
        throw new Exception($this->db->getErrorMsg(), 500);
      }

      // Convert the items to result objects.
      foreach ($rows as $row) {
        $row['language'] = $language;
        // Convert the item to a result object.
        $item = JArrayHelper::toObject($row, 'FinderIndexerResult');

        // Set the item type.
        $item->type_id = $this->type_id;

        // Set the mime type.
        $item->mime = $this->mime;

        // Set the item layout.
        $item->layout = $this->layout;

        // Set the extension if present
        if (isset($row->extension)) {
          $item->extension = $row->extension;
        }

        // Add the item to the stack.
        $items[] = $item;
      }
    }
    $db->setTranslate($oldTranslation);
    $db->getLanguage($oldLanguage);
    return $items;
  }

  /**
   * Method to get the URL for the item. The URL is how we look up the link
   * in the Finder index.
   *
   * @param   integer  $id         The id of the item.
   * @param   string   $extension  The extension the category is in.
   * @param   string   $view       The view for the URL.
   *
   * @return  string  The URL of the item.
   *
   * @since   2.5
   */
  protected function getURL($id, $extension, $view, $language = '*') {
    if ($language != '*') {
      return 'index.php?option=' . $extension . '&view=' . $view . '&id=' . $id . '&lang='.$language;
    } else {
      return 'index.php?option=' . $extension . '&view=' . $view . '&id=' . $id;
    }

  }

}