<?php
/**
 * @version		$Id$
 * @package		Joomla.Site
 * @subpackage	mod_languages
 * @copyright	Copyright (C) 2005 - 2011 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

jimport('joomla.language.helper');
jimport('joomla.utilities.utility');

abstract class modJdLanguageHelper
{
	public static function getLink($target) {
		$app = JFactory::getApplication();
		$menu = $app->getMenu();
		$active = $menu->getActive();
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('path, id, home, title');
		$query->from('#__menu');
		$query->where('id='.$active->id);
		$query->where('language in ('.$db->q($target).', '.$db->q('*').')');
		$db->setQuery($query);
	
		//replace current language with target language
		$orig_lang = $db->getLanguage();
		$db->setLanguage($target);
		$menuitem = $db->loadObject();
		$db->setLanguage($orig_lang);

		$option = JRequest::getCmd('option');
		$view = JRequest::getCmd('view');
		$layout = JRequest::getString('layout');
		$id = JRequest::getInt('id');

		$link = substr($target, 0, 2).'/';

		if ($menuitem && !$menuitem->home) {
			$link .= $menuitem->path;

			$query = array();
			if ($option && $active->query['option'] != $option) {
				$query[] = 'option='.$option;
			}
		
			if ($view && $active->query['view'] != $view) {
				$query[] = 'view='.$view;
			}
		
			if ($id && $active->query['id'] != $id) {
				$query[] = 'id='.$id;
			}
		
			if ($layout && $active->query['layout'] != $layout) {
				$query[] = 'layout='.$layout;
			}
		
			if (!empty($query)) {
				$link .= '?'.implode('&', $query);
			}
		}
		
		//check if we use sef_rewrite
		$config = JFactory::getConfig();
		if (!$config->get('sef_rewrite')) {
			$link = '/index.php/'.$link;
		} else {
			$link = '/'.$link;
		}

		return array($link, $menuitem->title);
	}
}
