<?php
/**
 * @package jDiction
 * @link http://joomla.itronic.at
 * @copyright	Copyright (C) 2011 ITronic Harald Leithner. All rights reserved.
 * @license GNU General Public License v3
 *
 * This file is part of jDiction.
 *
 * jDiction is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * jDiction is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jDiction.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modeladmin');

/**
 * Methods supporting a list of Translation records.
 *
 * @package		jDiction
 */
class jDictionModelTranslation extends JModelAdmin {
	/**
	 * @var		string	The prefix to use with controller messages.
	 */
	protected $text_prefix = 'COM_JDICTION_TRANSLATION';

  /**
   * the untranslated object
   * @var object
   */
  protected $original;

  /**
   * the reference entry
   * @var object
   */
  protected $reference;

	public function getItem($pk = null) {
	
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('idReference as id, referenceOption as `option`, referenceView as view, referenceLayout as layout');
		$query->from('#__jd_store');
		$query->where('idJdStore='.$db->quote($pk));
		
		$db->setQuery($query);
		
		$this->reference = $db->loadObject();
		$this->loadForm($this->reference);

		return $this->reference;
	}
	
	public function getOriginal($pk) {
		$jd = jdiction::getInstance();
		$table = $jd->getTableByView($this->reference->option, $this->reference->view);
    /*
    require_once JPATH_ADMINISTRATOR.'/components/'.$component['__metadata']['component'].'/tables/'.$component['__metadata']['table'].'.php';
    $table = JTable::getInstance($component['__metadata']['table'], 'cmxTable');
    */
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from($table->name);
		$query->where($db->quoteName($table->key).'='.$db->quote($pk));
		$db->setQuery($query);
		$this->original = $db->loadObject();

		return $this->original;
	}
	
	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return	mixed	The data for the form.
	 * @since	1.6
	 */
	protected function loadFormData()	{
		
		$db = JFactory::getDbo();
		
		$query = $db->getQuery(true);
		$query->select('s.*,l.lang_code');
		$query->from('#__jd_store s');
		$query->join('left', '#__languages l on s.idLang = l.lang_id');
		$query->where('idReference='.$db->quote($this->reference->id));
		$query->where('referenceTable='.$db->quote($this->reference->table));
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		$array = Array();
		foreach ($rows as $row) {
			$array[$row->lang_code] = jDictionTranslationHelper::decodeTranslation($row->value);
			$array[$row->lang_code]['idJdStore'] = $row->idJdStore;
		}

		return $array;

		/** @TODO make it more joomla */
		
		// Check the session for previously entered form data.
    /*
		$data = JFactory::getApplication()->getUserState('com_jdiction.edit.translation.data', array());
		if (empty($data)) {
			$data = $this->getItem();
		}
		if (is_object($data)) {
			$data = JArrayHelper::fromObject($data);
		}
		
		return $data;
    */
	}
	
	/**
	 * returns all languages
	 */
	public function getLanguages() {
		$jd = jdiction::getInstance();
		$languages = $jd->getLanguages();
		return $languages;
	}
	
	/**
	 * Load component
	 */
	public function loadForm(&$reference, $source=null, $options = array('control'=>'jform'), $clear = false, $xpath = false) {

		if (!$reference->option ||
			!$reference->view ||
			!$reference->layout ||
			!$reference->id) {
			return false;
		}
		$lang = JFactory::getLanguage();
		$lang->load($reference->option, JPATH_ADMINISTRATOR.'/components/'.$reference->option)
			|| $lang->load($reference->option);
		
		$this->reference = $reference;
		$jd = jdiction::getInstance();
    $view = $jd->getView($reference->option, $reference->view);
		$reference->table = $view->primarytable;
		jimport('jdiction.form.form');
		$reference->form = new JDForm($reference->option, $options, $reference);

		$langform = $view->form;

		$reference->form->load($langform, true, '');

		if ($options['load_data'] !== false) {
			$array = $this->loadFormData();

			$reference->data = $array;
			$reference->form->bind($array);
		}

		return $reference;
	}
	 
		
	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param	type	The table type to instantiate
	 * @param	string	A prefix for the table class name. Optional.
	 * @param	array	Configuration array for model. Optional.
	 * @return	JTable	A database object
	 * @since	1.6
	 */
	public function getTable($type = 'store', $prefix = 'jDictionTable', $config = array()) {
		return parent::getTable($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param	array	$data		Data for the form.
	 * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return	mixed	A JForm object on success, false on failure
	 * @since	1.6
	 */
	public function getForm($data = array(), $loadData = true) {
		$input = JFactory::getApplication()->input;
		$option = $input->get('jd_option', false, 'cmd');
		if ($option) {
			$reference = new stdClass;
			$reference->option = $option;
			$reference->view 	 = $input->get('jd_view', false, 'cmd');
			$reference->layout = $input->get('jd_layout', false, 'cmd');
			$reference->id 	   = $input->get('jd_id', false, 'int');
		} else {
			JError::raiseError(500, 'No Component given');
		}

		// Get the form.
		$this->loadForm($reference, 'translation', array('control' => 'jdiction', 'load_data' => $loadData));
		if (empty($reference->form)) {
			return false;
		}

		$reference->form->bind($data);
		return $reference;
	}
	
	/**
	 * Method to save the form data.
	 *
	 * @param	array	$data	The form data.
	 *
	 * @return	boolean	True on success.
	 * @since	1.6
	 */
	public function save($langdata)	{
		// Initialise variables;
		$dispatcher = JDispatcher::getInstance();
		$table		= $this->getTable();
		$key			= $table->getKeyName();
		$pk			= (!empty($data[$key])) ? $data[$key] : (int)$this->getState($this->getName().'.id');
		$isNew		= true;
		$status = JFactory::getApplication()->input->get('jdiction', array(), 'array');

		$db = JFactory::getDbo();

		// Include the content plugins for the on save events.
		//JPluginHelper::importPlugin('content');

		$query = $db->getQuery(true);
		foreach($this->getLanguages() as $language) {
			if (!isset($langdata[$language->lang_code])) {
				continue;
			}			
			// Allow an exception to be throw.
			try {
				
				$query->clear();
				$query->select('idJdStore');
				$query->from('#__jd_store');
				$query->where($db->quoteName('idReference').'='.$db->quote($this->reference->id));
				$query->where($db->quoteName('referenceTable').'='.$db->quote($this->reference->table));
				$query->where($db->quoteName('idLang').'='.$db->quote($language->lang_id));
				$db->setQuery($query);
        $pk = (int) $db->loadResult();
				
				// Load the row if saving an existing record.
				if ($pk > 0) {
					$table->load($pk);
					$isNew = false;
				}
				$data = Array();
				$data['value'] = jDictionTranslationHelper::decodeTranslation($table->value);
				
				$data['idJdStore'] = $pk;
				$data['idLang'] = $language->lang_id;
				$data['idReference'] = $this->reference->id;
				$data['referenceTable'] = $this->reference->table;
				$data['referenceOption'] = $this->reference->option;
				$data['referenceView'] = $this->reference->view;
				$data['referenceLayout'] = $this->reference->layout;

				foreach($langdata[$language->lang_code] as $k=>$item) {
					switch($status[$language->lang_code][$k]) {
						case 'remove':
							unset($langdata[$language->lang_code][$k]);
							break;
						case 'unchanged':
							if ($data['referenceTable'] == 'content' && $k == 'articletext') {
								if (!isset($data['value']['introtext'])) {
									unset($langdata[$language->lang_code][$k]);
								}
							} else {
								if (!isset($data['value'][$k])) {
									unset($langdata[$language->lang_code][$k]);
								}
							}
							break;
						case 'changed':
						default:
					}
				}


        /* Standby code, part moved to jdiction getTranslation function
				if ($data['referenceTable'] == 'content' && isset($langdata[$language->lang_code]['articletext'])) {
					$pattern = '#<hr\s+id=("|\')system-readmore("|\')\s*\/*>#i';
					$tagPos	= preg_match($pattern, $langdata[$language->lang_code]['articletext']);
		
					if ($tagPos == 0) {
						$langdata[$language->lang_code]['introtext'] = $langdata[$language->lang_code]['articletext'];
						$langdata[$language->lang_code]['fulltext'] = '';
					} else {
						list($langdata[$language->lang_code]['introtext'], $langdata[$language->lang_code]['fulltext']) = preg_split($pattern, $langdata[$language->lang_code]['articletext'], 2);
					}
				}
         */

				$data['value'] = jDictionTranslationHelper::encodeTranslation($langdata[$language->lang_code]);

				$data['modified'] = JFactory::getDate()->toSql();
				$data['modified_by'] = 0;
				if ($langdata[$language->lang_code]['state']) {
					$data['state'] = $langdata[$language->lang_code]['state'];
				} else {
					$data['state'] = 1;
				}

				// Bind the data.
				if (!$table->bind($data)) {
					$this->setError($table->getError());
					return false;
				}
	
				// Prepare the row for saving
				$this->prepareTable($table);
	
				// Check the data.
				if (!$table->check()) {
					$this->setError($table->getError());
					return false;
				}
	
				// Trigger the onContentBeforeSave event.
				$result = $dispatcher->trigger($this->event_before_save, array($this->option.'.'.$this->name, &$table, $isNew));
				if (in_array(false, $result, true)) {
					$this->setError($table->getError());
					return false;
				}
	
				// Store the data.
				if (!$table->store()) {
					$this->setError($table->getError());
					return false;
				}
	
				// Clean the cache.
				$cache = JFactory::getCache('jDiction');
				$cache->clean();
	
				// Trigger the onContentAfterSave event.
				$dispatcher->trigger($this->event_after_save, array($this->option.'.'.$this->name, &$table, $isNew));
			}
			catch (Exception $e)
			{
				$this->setError($e->getMessage());
	
				return false;
			}
			$pkName = $table->getKeyName();
			if (isset($table->$pkName)) {
				$this->setState($this->getName().'.id', $table->$pkName);
			}
			$this->setState($this->getName().'.new', $isNew);
		}

		return true;
	}

	/**
	 * Method to validate the form data.
	 *
	 * @param	object		$form		The form to validate against.
	 * @param	array		$data		The data to validate.
	 * @return	mixed		Array of filtered data if valid, false otherwise.
	 * @since	1.1
	 */
	function validate($form, $data)
	{
    // Filter and validate the form data.
			$data	= $form->form->filter($data);
    $return	= $form->form->validate($data);

			// Check for an error.
			if (JError::isError($return)) {
				$this->setError($return->getMessage());

				return false;
			}
	
			// Check the validation results.
			if ($return === false) {
				// Get the validation messages from the form.
				foreach ($form->form->getErrors() as $message) {
					$this->setError(JText::_($message));
				}
	
				return false;
			}

		return $data;
	}

} 
