<?php
/**
 * jDiction library entry point
 *
 * @package jDiction
 * @link http://joomla.itronic.at
 * @copyright	Copyright (C) 2011 ITronic Harald Leithner. All rights reserved.
 * @license GNU General Public License v3
 * @version 1.6.1 (18)
 *
 * This file is part of jDiction.
 *
 * jDiction is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * jDiction is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jDiction.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
defined('_JEXEC') or die;

define('JDICTION_TRANSLATION_STATUS_FULL', 1);
define('JDICTION_TRANSLATION_STATUS_OLD', 2);
define('JDICTION_TRANSLATION_STATUS_NONE', 3);
/* unused atm */
define('JDICTION_TRANSLATION_STATUS_PARTLY', 3);
define('JDICTION_TRANSLATION_STATUS_PUBLISHED', 5);
define('JDICTION_TRANSLATION_STATUS_UNPUBLISHED', 6);
define('JDICTION_TRANSLATION_STATUS_UNSET', 7);

//check for XML Support
if (function_exists("simplexml_load_string") && class_exists("SimpleXMLElement")) {
	define('JDICTION_TRANSLATION_USEXML', true);
} else {
	define('JDICTION_TRANSLATION_USEXML', false);
}

jimport('joomla.language.helper');
jimport('jdiction.helpers.translation');

class jDiction extends JObject {
	
	/** @var array holds all tables which could be translated jDiction */
	protected $tables = array();
	
	/** @var array holds all component task/view combination we can translate */
	protected $components = Array();
	
	/** @var array holding the cache for translations */
	protected $cache = Array();
	
	/** @var object local JDatabase object */
	protected $db;
	
	/**
	 * Dispatcher object
	 *
	 * @var JEventDispatcher
	 */
	protected $dispatcher;
	
	/**
	 * defines if jDiction is ready
	 * @var bool
	 */
	protected $ready=false;

	/**
	 * traceLog for debuging
	 */
	protected $traceLog=array();
	
	/**
	 * current trace Id
	 */
	protected $traceId=false;

	/**
	 * Returns the global jDiction object, only creating it
	 * if it doesn't already exist.
	 *
	 * @return jDiction	The global jDiction object
	 */
	public static function getInstance() {
		static $instance;

		if (!isset ($instance)) {
			$instance = new jDiction();
		}
		
		return $instance;
	}
	
	/**
	 * Initialise jDiction
	 */
	public function initialise() {
		$this->WorkaroundDatabaseConfig();
		//load Lanuage file
		$lang = JFactory::getLanguage();
		$lang->load('lib_jdiction', JPATH_LIBRARIES.'/jdiction');
		
		// load dispatcher and jdiction plugins
		JPluginHelper::importPlugin('jdiction');
		$this->dispatcher = JDispatcher::getInstance();
		
		$this->dispatcher->trigger('onjDictionAfterInitialise');
		
		$this->loadTables();
		
		$this->ready = true;

    $db = JFactory::getDbo();
    if (JFactory::getLanguage()->getTag() ==  JComponentHelper::getParams('com_languages')->get('site', 'en-GB')) {
      $db->setTranslate(false);
    }

	}
	
	public function WorkaroundDatabaseConfig() {
		if ($_REQUEST['option'] == 'com_config') {
			jimport('jdiction.form.fields.databaseconnection');
		}

	}
	
	/**
	 * check the status of jdiction
	 * @return bool the status of the library
	 */
	public function getStatus() {
		return $this->ready;
	}
	
	/** 
	 * load all core table definitions
	 */
	public function loadTables() {

    $cache = JFactory::getCache('jDiction');
//    $subdirs = $cache->get('sectionxmls');

    if (!$subdirs) {
      jimport('joomla.filesystem.folder');
      $dir = dirname(__FILE__).'/tables';
      $subdirs1 = JFolder::files($dir,'.xml', false, true);
      $subdirs2 = JFolder::files(JPATH_ADMINISTRATOR.'/components','jdiction.xml', true, true);

      $subdirs = array_merge($subdirs1, $subdirs2);

//      $cache->store($subdirs, 'sectionxmls');
    }

    $this->dispatcher->trigger('onjDictionBeforeLoadTables', array( &$subdirs));
		
		foreach ($subdirs as $path) {
			$this->parseTable($path);
		}

		$this->dispatcher->trigger('onjDictionAfterLoadTables', array( &$subdirs));

	}
	
	/**
	 * load xml definiation of a table with its component and views
	 */
	public function parseTable($xmlfile) {

		// Try to load the file
    $xml = simplexml_load_file($xmlfile);

    if ($xml === false) {
      return false;
    }

		// Check that it's a metadata file
		if ((string)$xml->getName() != 'jdiction') {
			return false;
		}
		
		$this->dispatcher->trigger('onjDictionParseTable', array(&$xml));

    $component = (string)$xml->component;

		foreach ($xml->sections->children() as $section) {
      $primarytable = '';
      foreach($section->tables->children() as $table) {
        if (!$primarytable) {
          $primarytable = (string)$table->name;
        }
        $this->tables[(string)$table->name]->name = (string)$table->name;
        $this->tables[(string)$table->name]->key = (string)$table->key;
        $this->tables[(string)$table->name]->class = (string)$table->class;
        $this->tables[(string)$table->name]->file = (string)$table->file;
        $this->tables[(string)$table->name]->cache->fullfetch = (string)$table->cache['fullfetch'];
        $this->tables[(string)$table->name]->exportfilter = (string)$table->exportfilter;
        $this->tables[(string)$table->name]->component = $component;
      }

      foreach($section->views->children() as $view) {
        $this->components[$component][(string)$view['name']]->name = (string)$view['name'];
        $this->components[$component][(string)$view['name']]->list = (string)$view['list'];
        $this->components[$component][(string)$view['name']]->layout = (string)$view['layout'];
        $this->components[$component][(string)$view['name']]->primarytable = $primarytable;
        $this->components[$component][(string)$view['name']]->default = ($view['default'] && strtoupper((string)$view['default']) != 'FALSE');
        // We need to export and reimport the xml object else we have the complete xml document as form
        $this->components[$component][(string)$view['name']]->form = simplexml_load_string($view->form->asXML());
      }

		}
    return true;
	}

  /**
   * Returns one or all compoents
   * @param string $component
   * @return array All views or all components
   */
  public function getComponent($component=null) {
		if (!$component) {
			return $this->components;
		} else {
			return $this->components[$component];
		}
	}

  /**
   * Returns the Component properties by table
   * @param string $table
   * @return bool|array returns a view list
   */
  public function getComponentByTable($table) {
    if ($this->tables[$table] && $this->components[$this->tables[$table]->component]) {
      return $this->components[$this->tables[$table]->component];
    }
    return false;
  }

  /**
   * Returns the table based on the component and the view
   * @param string $component
   * @param string $view
   * @return object
   */
  public function getTableByView($component, $view) {
    if ($this->components[$component]) {
      foreach($this->components[$component] as $jdview) {
        if ($jdview->name == $view or $jdview->list == $view) {
          return $this->tables[$this->components[$component][$jdview->name]->primarytable];
        }
      }
    }
    return false;
  }

  /**
 * Returns one or all tables
 * @param string $table
 * @return array All views or all components
 */
  public function getTable($table=null) {
    if (!$table) {
      return $this->tables;
    } else {
      return $this->tables[$table];
    }
  }

  /**
   * Returns one or all Views
   * @param string $view
   * @return array All views or all components
   */
  public function getView($component, $view) {
    if ($this->components[$component]) {
      foreach($this->components[$component] as $jdview) {
        if ($jdview->name == $view or $jdview->list == $view or ($jdview->default == 'true' and $view=='default')) {
          return $jdview;
        }
      }
    }
    return false;
  }

	
	/**
	 * Debug function to start and stop trace
	 */
	public function trace($start=true, $id=1) {
		$trace = true;

		if ($start) {
			$this->traceId = $id;
			if (array_key_exists($id, $this->traceLog)) {
				$this->traceLog[$id] = array();
			} else {
				$trace = $this->traceLog[$id];
			}
		} else {
			$trace = $this->traceLog[$id];
			unset($this->traceLog[$id]);
			$this->traceId = false;
		}
		return $trace;
	}
	
	public function addLog($msg) {
		if ($this->traceId) {
			$this->traceLog[$this->traceId] = array(
				'message' => $msg
			);
		}
	}
	
	/**
	 * translate content
	 */
	public function translate(&$rows, $language, &$metadata, $resulttype='BOTH', $key=null) {
		
		if (!$this->ready) {
			return false;
		}

		/* If we have no result we exit here */
		if (empty($rows)) {
			return false;
		}

		//find primary key for each table alias
		foreach($metadata['tables'] as $tablealias=>$table) {
			foreach($table['fields'] as $fieldid=>$field) {
				if (isset($field->orgname)) {
					$fieldName = $field->orgname;
				} else {
					$fieldName = $field->name;
				}
				
				if ($fieldName == $this->tables[$metadata['tablealias'][$tablealias]]->key) {
					$aliaskey[$tablealias] = $fieldid;
				}
			}
		}
		
		if (is_numeric($key) && $key < 0) {
			$rows = array($rows);
		}

		$newrows = array();
		//translate all rows
		if (is_array($rows) && count($rows)) {
			foreach($rows as $rowkey=>&$row) {
				$targetkey = $rowkey;
				foreach($metadata['tables'] as $tablealias=>$table) {
					if (array_key_exists($metadata['tablealias'][$tablealias], $this->tables)) {
						$translation = $this->getTranslation($metadata['tablealias'][$tablealias], $row[$aliaskey[$tablealias]], $language);
					} else {
						$translation = false;
					}
					/* Unset this row if it has state -3 (hide) */
					if ($translation) {
						if ($translation['__metadata']->state == -3) {
							unset($rows[$rowkey]);
							continue 2;
						}
					}
					
					foreach($table['fields'] as $fieldid=>$field) {
						if (isset($field->orgname)) {
							$fieldName = $field->orgname;
						} else {
							$fieldName = $field->name;
						}
						
						// Remove JD_MAGIC_KEY fields used to get primary key in table
						if (strpos($field->name, 'JD_MAGIC_KEY') !== false) {
							unset($row[$fieldid]);
							continue;
						}
						
						if ($translation) {
							if (array_key_exists($fieldName, $translation)) {
								//used for params
								// @todo rework with recrusive version
								if (is_array($translation[$fieldName])) {
									//works only for json atm
									$jsontmp = json_decode($row[$fieldid], true);
									foreach($translation[$fieldName] as $subkey=>$subvalue) {
										$jsontmp[$subkey] = $subvalue;
									}
									$row[$fieldid] = json_encode($jsontmp);
								} else {
									$row[$fieldid] = $translation[$fieldName];
								}
							}
						}
						
						if ($key) {
							if (is_numeric($key)) {
								if ($key==$fieldid) {
									$targetkey = $row[$fieldid];
								}
							} elseif (is_string($key)) {
								if (strtolower($key)==strtolower($fieldName)) {
									$targetkey = $row[$fieldid];
								}
							}
						}
					}
					
					//second turn to copy table to correct key and fieldnames
					foreach($table['fields'] as $fieldid=>$field) {
						// Remove JD_MAGIC_KEY fields used to get primary key in table
						if (strpos($field->name, 'JD_MAGIC_KEY') !== false) {
							continue;
						}
						switch(strtoupper($resulttype)) {
							case 'BOTH':
									$newrows[$targetkey][$fieldid] = $row[$fieldid];
									$newrows[$targetkey][$field->name] = $row[$fieldid];
								break;
							case 'NUM':
									$newrows[$targetkey][$fieldid] = $row[$fieldid];
								break;
							case 'ASSOC':
									$newrows[$targetkey][$field->name] = $row[$fieldid];
								break;
						}
					}
				}
			}
		}
		unset($row);

		if (is_numeric($key) && $key < 0) {
			$rows = current($newrows);
		} else {
			$rows = $newrows;
		}
    return true;
	}
	
	public function getTranslation($reftable, $refid, $language) {
    if (array_key_exists($reftable, $this->cache)) {
      if (array_key_exists($language, $this->cache[$reftable])) {
        if (array_key_exists($refid, $this->cache[$reftable][$language])) {
					return $this->cache[$reftable][$language][$refid];
				} else {
          if ($this->tables[$reftable]->cache->fullfetch) {
            return false;
          }
        }
			}
		}

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__jd_store');
		$query->where('idLang='.$db->quote($language));
    if (!$this->tables[$reftable]->cache->fullfetch) {
      $query->where('idReference='.$db->quote($refid));
    }
		$query->where('referenceTable='.$db->quote($reftable));
		
		//save current state
		$old = $db->setTranslate(false);
		$oldquery = $db->getQuery();

		$db->setQuery($query);
		$translations = $db->loadObjectList();

		//restore old state
		$db->setTranslate($old);
		$db->setQuery($oldquery);

    if ($translations) {
      foreach($translations as $translation) {
        $this->cache[$reftable][$language][$translation->idReference] = jDictionTranslationHelper::decodeTranslation($translation->value);
        unset($translation->value);
        // Workaround for articletext
        if ($reftable == '#__content') {
          if (array_key_exists('articletext', $this->cache[$reftable][$language][$translation->idReference])) {
            $pattern = '#<hr\s+id=("|\')system-readmore("|\')\s*\/*>#i';
            $tagPos = preg_match($pattern, $this->cache[$reftable][$language][$translation->idReference]['articletext']);

            if ($tagPos == 0) {
              $this->cache[$reftable][$language][$translation->idReference]['introtext'] = $this->cache[$reftable][$language][$translation->idReference]['articletext'];
              $this->cache[$reftable][$language][$translation->idReference]['fulltext'] = '';
            } else {
              list($this->cache[$reftable][$language][$translation->idReference]['introtext'],
                $this->cache[$reftable][$language][$translation->idReference]['fulltext']
                ) = preg_split($pattern, $this->cache[$reftable][$language][$translation->idReference]['articletext'], 2);
            }

          }
        }
        // Workaround for articletext
        $this->cache[$reftable][$language][$translation->idReference]['__metadata'] = $translation;
      }
		  if ($this->cache[$reftable][$language][$refid]) {
			  return $this->cache[$reftable][$language][$refid];
      } else {
        return false;
      }
		} else {
      $this->cache[$reftable][$language] = array();
    }
		return false;
	}

	/**
	 * returns the status of the translation
	 * @param string $reftable table name
	 * @param int $refid table primary key
	 * @param mixed $language language as lang_code or lang_id or object
   * @return int the status of the translation
	 */
	public function getTranslationStatus($reftable, $refid, $language=null) {
		$status = 0;
    $languages = $this->getLanguage($language);

		foreach($languages as $language) {
			$translation = $this->getTranslation($reftable, $refid, $language->lang_id);
			if ($translation) {
				if ($translation['__metadata']->state == 2) {
					$status = JDICTION_TRANSLATION_STATUS_OLD;
				} else {
					$status = JDICTION_TRANSLATION_STATUS_FULL;
				}
			} else {
				$status = JDICTION_TRANSLATION_STATUS_NONE;
			}
		}
		return $status;
	}

  /**
   * Normalize language code
   * @param null|string|int|object $language The language as language Tag or ID or Object
   * @return array all $languages or just the given one
   */

  public function getLanguage($language=null) {

    $languages = $this->getLanguages(true);

    if ($language) {
      if (is_object($language)) {
        if (property_exists($language, 'lang_id')) {
          $language = $language->lang_id;
        } else {
          $language = $language->lang_code;
        }
      }
      if (is_numeric($language)) {
        foreach($languages as $k=>$lang) {
          if ($lang->lang_id !== $language) {
            unset($languages[$k]);
          }
        }
      } else {
        foreach($languages as $k=>$lang) {
          if ($lang->lang_code !== $language) {
            unset($languages[$k]);
          }
        }
      }
    }

    return $languages;
  }
  /**
   * Returns all languages except the primary language
   *
   * @param bool $all If true include primary language
   * @return array languages
   */
  public function getLanguages($all=false) {
		$languages = JLanguageHelper::getLanguages();
		if (!$all) {
			$config = JFactory::getConfig();
			foreach($languages as $k=>$language) {
				if ($language->lang_code == $config->get('language')) {
					unset($languages[$k]);
				}
			}
		}
		
		return $languages;
	}

  /**
   * @return mixed the current Language
   */
  public function getCurrentLanguage() {
    $lang = $this->getLanguage(JFactory::getLanguage()->getTag());
    return current($lang);
  }
	
	/**
	 * Adds the translation toolbar button to the toolbar based on the
	 * given parameters.
	 *
	 */
	public function addToolbar() {
		//check if we are in backend
		$app = JFactory::getApplication();
		if (!$app->isAdmin()) {
			return;
		}

    $input = JFactory::getApplication()->input;

    $option = $input->get('option', false, 'cmd');
		$view 	= $input->get('view', false, 'cmd');
		$layout = $input->get('layout', false, 'string');
		
		$table = $this->getTableByView($option, $view);
		if (!$option || !$view || !$layout) {
			return;
		}

		$id = $input->get($table->key, 0, 'int');

		//Load ToolBar
		$bar = JToolBar::getInstance('toolbar');
		
		//Add Stylesheet for button icons
		JHTML::_('stylesheet','administrator/components/com_jdiction/assets/style.css', array(), false); 

    if (!array_key_exists($option, $this->components)) {
      return;
    }

		if (array_key_exists($view, $this->components[$option])) {
			if ($this->components[$option][$view]->layout == $layout) {
        if ($id == 0) {
          $bar->appendButton('Link', 'jdiction-component', 'LIB_JDICTION_TOOLBAR_TRANSLATE', "javascript:alert('".JText::_('LIB_JDICTION_SAVE_FIRST', true)."');");
        } else {
          $bar->appendButton('Popup', 'jdiction-component', 'LIB_JDICTION_TOOLBAR_TRANSLATE', 'index.php?option=com_jdiction&view=translation&tmpl=component&layout=popup&jd_option='.$option.'&jd_view='.$view.'&jd_layout='.$layout.'&jd_id='.$id, 'window.getSize().x-100', 'window.getSize().y-100');
        }
			}
		}
	}
	
	public function getTranslationLink($component, $view, $layout, $id, $popup=true) {
		
		$link = 'index.php?option=com_jdiction&view=translation';
		if ($popup) {
			$link .= '&tmpl=component&layout=popup';
		} else {
			$link .= '&layout=edit';
		}
		$link .= '&jd_option='.$component.'&jd_view='.$view.'&jd_layout='.$layout.'&jd_id='.$id;
		
		return $link;
	}
}