<?php
/**
 * @package jDiction
 * @link http://joomla.itronic.at
 * @copyright	Copyright (C) 2011 ITronic Harald Leithner. All rights reserved.
 * @license GNU General Public License v3
 *
 * This file is part of jDiction.
 *
 * jDiction is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * jDiction is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jDiction.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modeladmin');

/**
 * Methods supporting a list of Translation records.
 *
 * @package		jDiction
 */
class jDictionModelImport extends JModelAdmin {
	/**
	 * @var		string	The prefix to use with controller messages.
	 */
	protected $text_prefix = 'COM_JDICTION_UPLOAD';

	/**
	 * returns all languages
	 */
	public function getLanguages() {
		$jd = jdiction::getInstance();
		$languages = $jd->getLanguages();
		return $languages;
	}
	
	 
		
	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param	type	The table type to instantiate
	 * @param	string	A prefix for the table class name. Optional.
	 * @param	array	Configuration array for model. Optional.
	 * @return	JTable	A database object
	 * @since	1.6
	 */
	public function getTable($type = 'store', $prefix = 'jDictionTable', $config = array()) {
		return parent::getTable($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param	array	$data		Data for the form.
	 * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return	mixed	A JForm object on success, false on failure
	 * @since	1.6
	 */
	public function getForm($data = array(), $loadData = true) {
		// Get the form.
		$form = $this->loadForm('com_jdiction.upload', 'upload', array('control' => 'jform', 'load_data' => $loadData));
								
		if (empty($form)) {
			return false;
		}
		return $form;
	}
	
	/**
	 * returns the url to the list
	 */
  public function getListUrl($option, $view) {

    $jd = jdiction::getInstance();
    $component = $jd->getComponent($option);
    $view = $component[$view]->list;

    return $view;
  }
	
	/**
	 * Method to save the form data.
	 *
	 * @param	array	$data	The form data.
	 *
	 * @return	boolean	True on success.
	 * @since	1.6
	 */
	public function save($langdata)
	{
		// Initialise variables;
		$dispatcher = JDispatcher::getInstance();
		$table		= $this->getTable();
		$key			= $table->getKeyName();
		$pk			= (!empty($data[$key])) ? $data[$key] : (int)$this->getState($this->getName().'.id');
		$isNew		= true;
		$status = (array)JRequest::getVar('jdiction');

		$db = JFactory::getDbo();

		// Include the content plugins for the on save events.
		//JPluginHelper::importPlugin('content');

		$query = $db->getQuery(true);
		foreach($this->getLanguages() as $language) {
			
			// Allow an exception to be throw.
			try {
				
				$query->clear();
				$query->select('s.idJdStore');
				$query->from('#__jd_store s');
				$query->where('idReference='.$db->quote($this->reference->id));
				$query->where('referenceTable='.$db->quote($this->reference->table));
				$query->where('idLang='.$db->quote($language->lang_id));
				$db->setQuery($query);
				$row = $db->loadObject();
				
				$pk = (int) $row->idJdStore;
				
				// Load the row if saving an existing record.
				if ($pk > 0) {
					$table->load($pk);
					$isNew = false;
				}
				$data = Array();
				$data['value'] = jDictionTranslationHelper::decodeTranslation($table->value);
				
				$data['idJdStore'] = $pk;
				$data['idLang'] = $language->lang_id;
				$data['idReference'] = $this->reference->id;
				$data['referenceTable'] = $this->reference->table;
				$data['referenceOption'] = $this->reference->option;
				$data['referenceView'] = $this->reference->view;
				$data['referenceLayout'] = $this->reference->layout;

				foreach($langdata[$language->lang_code] as $k=>$item) {
					switch($status[$language->lang_code][$k]) {
						case 'remove':
							unset($langdata[$language->lang_code][$k]);
							break;
						case 'unchanged':
							if ($data['referenceTable'] == 'content' && $k == 'articletext') {
								if (!isset($data['value']['introtext'])) {
									unset($langdata[$language->lang_code][$k]);
								}
							} else {
								if (!isset($data['value'][$k])) {
									unset($langdata[$language->lang_code][$k]);
								}
							}
							break;
						case 'changed':
						default:
					}
				}

				if ($data['referenceTable'] == 'content' && isset($langdata[$language->lang_code]['articletext'])) {
					$pattern = '#<hr\s+id=("|\')system-readmore("|\')\s*\/*>#i';
					$tagPos	= preg_match($pattern, $langdata[$language->lang_code]['articletext']);
		
					if ($tagPos == 0) {
						$langdata[$language->lang_code]['introtext'] = $langdata[$language->lang_code]['articletext'];
						$langdata[$language->lang_code]['fulltext'] = '';
					} else {
						list($langdata[$language->lang_code]['introtext'], $langdata[$language->lang_code]['fulltext']) = preg_split($pattern, $langdata[$language->lang_code]['articletext'], 2);
					}
				}

				$data['value'] = jDictionTranslationHelper::encodeTranslation($langdata[$language->lang_code]);
				jimport('joomla.utilities.date');
				$data['modified'] = JFactory::getDate()->toSQL();
				$data['modified_by'] = 0;
				if ($langdata[$language->lang_code]['state']) {
					$data['state'] = $langdata[$language->lang_code]['state'];
				} else {
					$data['state'] = 1;
				}
				

				// Bind the data.
				if (!$table->bind($data)) {
					$this->setError($table->getError());
					return false;
				}
	
				// Prepare the row for saving
				$this->prepareTable($table);
	
				// Check the data.
				if (!$table->check()) {
					$this->setError($table->getError());
					return false;
				}
	
				// Trigger the onContentBeforeSave event.
				$result = $dispatcher->trigger($this->event_before_save, array($this->option.'.'.$this->name, &$table, $isNew));
				if (in_array(false, $result, true)) {
					$this->setError($table->getError());
					return false;
				}
	
				// Store the data.
				if (!$table->store()) {
					$this->setError($table->getError());
					return false;
				}
	
				// Clean the cache.
				$cache = JFactory::getCache('jDiction');
				$cache->clean();
	
				// Trigger the onContentAfterSave event.
				$dispatcher->trigger($this->event_after_save, array($this->option.'.'.$this->name, &$table, $isNew));
			}
			catch (Exception $e)
			{
				$this->setError($e->getMessage());
	
				return false;
			}
			$pkName = $table->getKeyName();
			if (isset($table->$pkName)) {
				$this->setState($this->getName().'.id', $table->$pkName);
			}
			$this->setState($this->getName().'.new', $isNew);
		}

		return true;
	}

	/**
	 * Method to validate the form data.
	 *
	 * @param	object		$form		The form to validate against.
	 * @param	array		$data		The data to validate.
	 * @return	mixed		Array of filtered data if valid, false otherwise.
	 * @since	1.1
	 */
	function validate($form, $data)
	{
		// Filter and validate the form data.
			$data	= $form->form->filter($data);
			$return	= $form->form->validate($data);

			// Check for an error.
			if (JError::isError($return)) {
				$this->setError($return->getMessage());

				return false;
			}
	
			// Check the validation results.
			if ($return === false) {
				// Get the validation messages from the form.
				foreach ($form->form->getErrors() as $message) {
					$this->setError(JText::_($message));
				}
	
				return false;
			}
		return $data;
	}

} 
